﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/fs_MemoryReportInfo.h>

#include <nn/fs/detail/fs_ResultHandlingUtility.h>
#include <nn/fssrv/sf/fssrv_IFileSystemProxy.h>

#include "fs_FileSystemProxyServiceObject.h"

namespace nn { namespace fs {

Result GetAndClearMemoryReportInfo(MemoryReportInfo* pOutMemoryReportInfo) NN_NOEXCEPT
{
    NN_FS_RESULT_THROW_UNLESS(pOutMemoryReportInfo != nullptr, ResultNullptrArgument());

    nn::sf::SharedPointer<nn::fssrv::sf::IFileSystemProxy> fileSystemProxy = detail::GetFileSystemProxyServiceObject();
    MemoryReportInfo memoryReportInfo;
    NN_FS_RESULT_DO(fileSystemProxy->GetAndClearMemoryReportInfo(nn::sf::Out<MemoryReportInfo>(&memoryReportInfo)));
    *pOutMemoryReportInfo = memoryReportInfo;
    NN_RESULT_SUCCESS;
}

}}
