﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/os/os_ReaderWriterLock.h>


namespace nn { namespace fs { namespace detail {

class FileDataCacheAccessor;

class GlobalFileDataCacheAccessorReadableScopedPointer
{
    NN_DISALLOW_COPY(GlobalFileDataCacheAccessorReadableScopedPointer);

private:
    FileDataCacheAccessor* m_Pointer;
    os::ReaderWriterLock* m_pLock;

public:
    GlobalFileDataCacheAccessorReadableScopedPointer() NN_NOEXCEPT
        : m_Pointer(nullptr)
        , m_pLock(nullptr)
    {
    }
    ~GlobalFileDataCacheAccessorReadableScopedPointer() NN_NOEXCEPT
    {
        if (m_pLock)
        {
            m_pLock->ReleaseReadLock();
        }
    }
    FileDataCacheAccessor* Get() const NN_NOEXCEPT
    {
        return m_Pointer;
    }
    void Set(FileDataCacheAccessor* pointer, os::ReaderWriterLock* pLock) NN_NOEXCEPT
    {
        if (m_pLock && m_pLock != pLock)
        {
            m_pLock->ReleaseReadLock();
        }
        m_Pointer = pointer;
        m_pLock = pLock;
    }
    FileDataCacheAccessor* operator->() const NN_NOEXCEPT
    {
        return m_Pointer;
    }
    NN_EXPLICIT_OPERATOR bool() const NN_NOEXCEPT
    {
        return m_Pointer != nullptr;
    }
};

bool IsGlobalFileDataCacheEnabled() NN_NOEXCEPT;
bool TryGetGlobalFileDataCacheAccessor(GlobalFileDataCacheAccessorReadableScopedPointer* pOutPointer) NN_NOEXCEPT;

}}}
