﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/fs_IEventNotifier.h>
#include <nn/fssrv/sf/fssrv_IEventNotifier.h>

#include "fs_EventNotifierObjectAdapter.h"
#include <nn/fs/detail/fs_ResultHandlingUtility.h>

namespace nn { namespace fs { namespace detail {

    EventNotifierObjectAdapter::EventNotifierObjectAdapter(nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>&& eventNotifierObject) NN_NOEXCEPT
    : m_EventNotifierObject(eventNotifierObject)
    {
    }

    EventNotifierObjectAdapter::~EventNotifierObjectAdapter() NN_NOEXCEPT
    {
    }

    Result EventNotifierObjectAdapter::DoBindEvent(nn::os::SystemEventType* systemEvent, nn::os::EventClearMode clearMode) NN_NOEXCEPT
    {
        nn::sf::NativeHandle handle;
        NN_FS_RESULT_DO(m_EventNotifierObject->GetEventHandle(&handle));
        nn::os::AttachReadableHandleToSystemEvent(systemEvent, handle.GetOsHandle(), handle.IsManaged(), clearMode);
        handle.Detach();
        NN_RESULT_SUCCESS;
    }

}}}
