﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/fs/fs_FileSystem.h>
#include <nn/fs/fs_Result.h>
#include <nn/fs/detail/fs_AccessLog.h>
#include "shim/fs_Library.h"
#include "fs_FileSystemAccessor.h"
#include "fs_MountUtility.h"
#include <nn/fs/detail/fs_ResultHandlingUtility.h>
#include <nn/fs/fsa/fs_IFileSystem.h>

namespace nn { namespace fs {

Result CreateFile(const char* path, int64_t size, int option) NN_NOEXCEPT
{
    detail::FileSystemAccessor* system;
    NN_FS_RESULT_DO(NN_DETAIL_FS_ACCESS_LOG_FILESYSTEM_FOR_FINDFILESYSTEM(
        detail::FindFileSystem(&system, path), NN_DETAIL_FS_ACCESS_LOG_FORMAT_PATH, path));

    NN_FS_RESULT_DO(NN_DETAIL_FS_ACCESS_LOG_FILESYSTEM(system->CreateFile(detail::GetSubPath(path), size, option), nullptr, system, NN_DETAIL_FS_ACCESS_LOG_FORMAT_PATH_AND_SIZE, path, size));
    NN_RESULT_SUCCESS;
}

Result GetFreeSpaceSize(int64_t* outValue, const char* path) NN_NOEXCEPT
{
    detail::FileSystemAccessor* system;
    NN_FS_RESULT_DO(detail::FindFileSystem(&system, path));

    NN_FS_RESULT_DO(system->GetFreeSpaceSize(outValue, detail::GetSubPath(path)));
    NN_RESULT_SUCCESS;
}

Result GetTotalSpaceSize(int64_t* outValue, const char* path) NN_NOEXCEPT
{
    detail::FileSystemAccessor* system;
    NN_FS_RESULT_DO(detail::FindFileSystem(&system, path));

    NN_FS_RESULT_DO(system->GetTotalSpaceSize(outValue, detail::GetSubPath(path)));
    NN_RESULT_SUCCESS;
}

Result SetConcatenationFileAttribute(const char* path) NN_NOEXCEPT
{
    detail::FileSystemAccessor* system;
    NN_FS_RESULT_DO(detail::FindFileSystem(&system, path));

    NN_FS_RESULT_DO(system->QueryEntry(nullptr, 0, nullptr, 0, fsa::QueryId::SetConcatenationFileAttribute, detail::GetSubPath(path)));
    NN_RESULT_SUCCESS;

}



}}
