﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/fs_ResultPrivate.h>
#include <nn/fssrv/sf/fssrv_IFileSystem.h>
#include <nn/result/result_HandlingUtility.h>

#include "fs_FileSystemAccessor.h"
#include "fs_UserMountTable.h"

namespace nn { namespace fs { namespace fsa {

Result Register(const char* name, std::unique_ptr<IFileSystem>&& fileSystem) NN_NOEXCEPT
{
    std::unique_ptr<detail::FileSystemAccessor> accessor(new detail::FileSystemAccessor(name, std::move(fileSystem)));
    NN_RESULT_THROW_UNLESS(accessor != nullptr, ResultAllocationMemoryFailedInRegisterA());

    return detail::Register(std::move(accessor));
}

Result Register(const char* name, std::unique_ptr<IFileSystem>&& fileSystem, std::unique_ptr<ICommonMountNameGenerator>&& mountNameGenerator) NN_NOEXCEPT
{
    std::unique_ptr<detail::FileSystemAccessor> accessor(new detail::FileSystemAccessor(name, std::move(fileSystem), std::move(mountNameGenerator)));
    NN_RESULT_THROW_UNLESS(accessor != nullptr, ResultAllocationMemoryFailedInRegisterB());

    return detail::Register(std::move(accessor));
}

Result Register(
    const char* name,
    std::unique_ptr<IFileSystem>&& fileSystem,
    std::unique_ptr<ICommonMountNameGenerator>&& mountNameGenerator,
    bool makeFileDataCacheAvailable,
    bool makePathBasedFileDataCacheAvailable,
    bool isMultiCommitSupported
    ) NN_NOEXCEPT
{
    std::unique_ptr<detail::FileSystemAccessor> accessor(new detail::FileSystemAccessor(name, std::move(fileSystem), std::move(mountNameGenerator)));
    NN_RESULT_THROW_UNLESS(accessor != nullptr, ResultAllocationMemoryFailedInRegisterB());

    accessor->SetFileDataCacheAttachable(makeFileDataCacheAvailable);
    accessor->SetPathBasedFileDataCacheAttachable(makePathBasedFileDataCacheAvailable);
    accessor->SetMultiCommitSupported(isMultiCommitSupported);

    return detail::Register(std::move(accessor));
}

void Unregister(const char* name) NN_NOEXCEPT
{
    detail::Unregister(name);
}

}}}
