﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Mutex.h>
#include <nn/fs/detail/fs_Newable.h>
#include "fs_FileSystemAccessor.h"
#include "fs_IntrusiveList.h"

namespace nn { namespace fs { namespace detail {

    class MountTable : public Newable
    {
    public:
        MountTable()
            : m_ListMutex(false)
        {
        }
        Result Mount(std::unique_ptr<FileSystemAccessor>&& fileSystem) NN_NOEXCEPT;
        void Unmount(const char* name) NN_NOEXCEPT;
        Result Find(FileSystemAccessor** outValue, const char* name) NN_NOEXCEPT;

    private:
        typedef IntrusiveList < FileSystemAccessor, IntrusiveListMemberNodeTraits<FileSystemAccessor, &FileSystemAccessor::m_ListNode>> ListType;
        ListType m_List;
        nn::os::Mutex m_ListMutex;

        bool CanAcceptMountName(const char* name);
    };

}}}
