﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace fs {

    template <typename T>
    class ScopedSetter
    {
    public:
        ScopedSetter(T& target, T value) NN_NOEXCEPT : m_Target(&target), m_Value(value){}
        ~ScopedSetter()
        {
            if (m_Target)
            {
                *m_Target = m_Value;
            }
        }
        void Set(T value) NN_NOEXCEPT
        {
            m_Value = value;
        }

        ScopedSetter(ScopedSetter&& r) NN_NOEXCEPT
        {
            m_Target = r.m_Target;
            m_Value = r.m_Value;
            r.Release();
        }

        ScopedSetter& operator=(ScopedSetter&& r) NN_NOEXCEPT
        {
            m_Target = r.m_Target;
            m_Value = r.m_Value;
            r.Release();
            return *this;
        }

    private:
        ScopedSetter(const ScopedSetter&) NN_NOEXCEPT;
        ScopedSetter& operator=(const ScopedSetter&)NN_NOEXCEPT;

        void Release() NN_NOEXCEPT
        {
            m_Target = nullptr;
        }

        T* m_Target;
        T m_Value;
    };

    template<typename T>
    inline ScopedSetter<T> MakeScopedSetter(T& target, T value) NN_NOEXCEPT
    {
        return ScopedSetter<T>(target, value);
    }
}}
