﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkLog.h>
#include <nn/fs/fs_Result.h>
#include <nn/fs/fs_Context.h>
#include <nn/os/os_SdkThreadLocalStorage.h>

namespace nn { namespace fs {

namespace
{
    os::SdkThreadLocalStorage g_TlsForContext;
    bool g_IsAutoAbortEnabled = true;
}

void SetEnabledAutoAbort(bool isEnabled) NN_NOEXCEPT
{
    g_IsAutoAbortEnabled = isEnabled;
}

AbortSpecifier DefaultResultHandler(Result result) NN_NOEXCEPT
{
    NN_UNUSED(result);
    if (g_IsAutoAbortEnabled)
    {
        return AbortSpecifier::Default;
    }
    else
    {
        return AbortSpecifier::ReturnResult;
    }
}

AbortSpecifier AllReturnResultHandler(Result result) NN_NOEXCEPT
{
    NN_UNUSED(result);
    return AbortSpecifier::ReturnResult;
}

// デフォルトコンテキスト
FsContext g_DefaultContext(DefaultResultHandler);

// (プリセット)
FsContext g_AllReturnContext(AllReturnResultHandler);


ScopedAutoAbortDisabler::ScopedAutoAbortDisabler() NN_NOEXCEPT
    : m_pPreviousContext(GetCurrentThreadFsContext())
{
    SetCurrentThreadFsContext(&g_AllReturnContext);
}

void SetDefaultFsContextResultHandler(const ResultHandler handler) NN_NOEXCEPT
{
    if (handler == nullptr)
    {
        g_DefaultContext.SetHandler(DefaultResultHandler);
    }
    else
    {
        g_DefaultContext.SetHandler(handler);
    }
}

void SetCurrentThreadFsContext(const FsContext* pContext) NN_NOEXCEPT
{
    g_TlsForContext.SetValue(reinterpret_cast<uintptr_t>(pContext));
}

const FsContext* GetCurrentThreadFsContext() NN_NOEXCEPT
{
    auto pContext = reinterpret_cast<FsContext*>(g_TlsForContext.GetValue());

    if (pContext == nullptr)
    {
        pContext = &g_DefaultContext;
    }

    return pContext;
}




}}
