﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.eth
{
    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/eth/eth_EthTypes.h>")]
    public struct MediaType
    {
    }
}

namespace nn.eth.sf
{
    // group of ethernet adapters
    [CppRefPath(@"<nn/eth/sfdl/eth.sfdl.h>")]
    public interface IEthInterfaceGroup : IServiceObject
    {
        [MethodId(0)]
        Result GetReadableHandle(Out<NativeHandle> handleOut);

        [MethodId(1)]
        Result Cancel();

        [MethodId(2)]
        Result GetResult();

        [MethodId(3)]
        Result GetInterfaceList(nn.sf.OutBuffer interfaceListOut);

        [MethodId(4)]
        Result GetInterfaceCount(Out<uint32_t> interfaceCount);
    }

    // individual ethernet adapter
    [CppRefPath(@"<nn/eth/sfdl/eth.sfdl.h>")]
    public interface IEthInterface : IServiceObject
    {
        [MethodId(0)]
        Result Initialize(Out<NativeHandle> handleOut, nn.sf.InBuffer interfaceName);

        [MethodId(1)]
        Result Cancel();

        [MethodId(2)]
        Result GetResult();

        [MethodId(3)]
        Result GetMediaList(nn.sf.OutBuffer mediaListOut);

        [MethodId(4)]
        Result SetMediaType(MediaType mediaTypeIn);

        [MethodId(5)]
        Result GetMediaType(Out<MediaType> mediaRequested, Out<MediaType> mediaCurrent, Out<uint32_t> eventCounter);
    }
}
