﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/eth/eth_Result.h>

namespace nn     {
namespace eth    {
namespace device {
namespace usb    {

class UsbDevice;
class UsbDeviceInfo;

extern nn::os::Mutex g_DeviceListLock;
extern nn::util::IntrusiveList<UsbDeviceInfo, nn::util::IntrusiveListBaseNodeTraits<UsbDeviceInfo>> g_UsbDeviceInfoList;

class UsbDeviceInfo :
    public nn::util::IntrusiveListBaseNode<UsbDeviceInfo>
{
protected:
    static uint32_t m_InterfaceCount;

public:
    uint16_t m_IdVendor;
    uint16_t m_IdProduct;

    UsbDeviceInfo(
        uint16_t idVendor,
        uint16_t idProduct
    ) NN_NOEXCEPT :
        m_IdVendor(idVendor),
        m_IdProduct(idProduct)
    {
        std::lock_guard<nn::os::Mutex> lock(g_DeviceListLock);
        g_UsbDeviceInfoList.push_back(*this);
    }

    virtual nn::Result Initialize(nn::usb::Host* pHost, nn::usb::InterfaceProfile* pProfile)
    {
        return ResultNotImplemented();
    }

    virtual nn::Result Finalize()
    {
        return ResultNotImplemented();
    }

};

}}}}
