﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn     {
namespace eth    {
namespace device {
namespace usb    {

// Link status bits shared through 'link' in LinkState
enum
{
    AX_INT_PPLS_LINK     = (1 << 0),
    AX_INT_SPLS_LINK     = (1 << 1),
    AX_INT_CABOFF_UNPLUG = (1 << 7),
};

// Returned on interrupt end point
struct LinkState
{
    uint16_t    res1;
    uint8_t     link;
    uint16_t    res2;
    uint8_t     status;
    uint16_t    res3;
} __attribute__((packed));

// Prepended to each frame on bulkout endpoint
struct TxPacketHeader
{
    uint32_t    packetLength;
    uint32_t    mssLength;
} __attribute__((packed));

// Placed at the tail of the data on bulkin endpoint
struct RxHeader
{
    uint16_t    packetCount;
    uint16_t    headerOffset;
} __attribute__((packed));

// Describes each frame on bulkin endpoint
struct RxPacketHeader
{
    uint16_t    packetFlags;
    uint16_t    packetLength : 13;
    uint16_t    packetErrors : 3;
} __attribute__((packed));

enum
{
    AXGE_PHY_ADDRESS = 3
};

enum
{
    AXGE_ACCESS_MAC             = 0x01,
    AXGE_ACCESS_PHY             = 0x02,
    AXGE_ACCESS_WAKEUP          = 0x03,
    AXGE_ACCESS_EEPROM          = 0x04,
    AXGE_ACCESS_EFUSE           = 0x05,
    AXGE_RELOAD_EEPROM_EFUSE    = 0x06,
    AXGE_WRITE_EFUSE_EN         = 0x09,
    AXGE_WRITE_EFUSE_DIS        = 0x0A,
    AXGE_ACCESS_MFAB            = 0x10,
};

enum
{
    AXGE_PLSR                   = 0x02,
    AXGE_EAR                    = 0x07,
    AXGE_EDLR                   = 0x08,
    AXGE_EDHR                   = 0x09,
    AXGE_ECR                    = 0x0a,
    AXGE_RCR                    = 0x0b,
    AXGE_NIDR                   = 0x10,
    AXGE_MFA                    = 0x16,
    AXGE_MSR                    = 0x22,
    AXGE_MMSR                   = 0x24,
    AXGE_GPIOCR                 = 0x25,
    AXGE_EPPRCR                 = 0x26,
    AXGE_RX_BULKIN_QCTRL        = 0x2e,
    AXGE_CLK_SELECT             = 0x33,
    AXGE_CRCR                   = 0x34,
    AXGE_CTCR                   = 0x35,
    AXGE_PWLHR                  = 0x54,
    AXGE_PWLLR                  = 0x55,
};

enum
{
    AXGE_BULK_DT_WR,
    AXGE_BULK_DT_RD,
    AXGE_INTERRUPT_DT,
    AXGE_N_TRANSFER,
};

enum
{
    EEP_RD                      = 0x04,
    EEP_WR                      = 0x08,
    EEP_BUSY                    = 0x10,
    EEP_SIZE                    = 0x20,
};

enum
{
    PLSR_USB_FS                 = 0x01,
    PLSR_USB_HS                 = 0x02,
    PLSR_USB_SS                 = 0x04,
};

enum
{
    RCR_STOP                    = 0x0000,
    RCR_PRO                     = 0x0001,
    RCR_AMALL                   = 0x0002,
    RCR_AB                      = 0x0008,
    RCR_AM                      = 0x0010,
    RCR_AP                      = 0x0020,
    RCR_SO                      = 0x0080,
    RCR_DROP_CRCE               = 0x0100,
    RCR_IPE                     = 0x0200,
    RCR_TX_CRC_PAD              = 0x0400,
};

enum
{
    MSR_GM                      = 0x0001,
    MSR_FD                      = 0x0002,
    MSR_ALWAYS_ONE              = 0x0004,
    MSR_EN_125MHZ               = 0x0008,
    MSR_RFC                     = 0x0010,
    MSR_TFC                     = 0x0020,
    MSR_RE                      = 0x0100,
    MSR_PS                      = 0x0200,
    MSR_SM                      = 0x0400,
    MSR_SBP                     = 0x0800,
    MSR_JUMBO                   = 0x8040,
};

enum
{
    MMSR_RWLC                   = 0x02,
    MMSR_RWMP                   = 0x04,
    MMSR_RWWF                   = 0x08,
    MMSR_RW_FLAG                = 0x10,
    MMSR_PME_POL                = 0x20,
    MMSR_PME_TYPE               = 0x40,
    MMSR_PME_IND                = 0x80
};

enum
{
    EPPRCR_BZ                   = 0x0010,
    EPPRCR_IPRL                 = 0x0020,
    EPPRCR_AUTODETACH           = 0x1000,
};

enum
{
    AXGE_CLK_SELECT_BCS         = 0x01,
    AXGE_CLK_SELECT_ACS         = 0x02,
    AXGE_CLK_SELECT_ACSREQ      = 0x10,
    AXGE_CLK_SELECT_ULR         = 0x08,
};

enum
{
    CRCR_IP                     = 0x01,
    CRCR_TCP                    = 0x02,
    CRCR_UDP                    = 0x04,
    CRCR_ICMP                   = 0x08,
    CRCR_IGMP                   = 0x10,
    CRCR_TCPV6                  = 0x20,
    CRCR_UDPV6                  = 0x40,
    CRCR_ICMPV6                 = 0x80,
};

enum
{
    CTCR_IP                     = 0x01,
    CTCR_TCP                    = 0x02,
    CTCR_UDP                    = 0x04,
    CTCR_ICMP                   = 0x08,
    CTCR_IGMP                   = 0x10,
    CTCR_TCPV6                  = 0x20,
    CTCR_UDPV6                  = 0x40,
    CTCR_ICMPV6                 = 0x80,
};

enum
{
    AXGE_CONFIG_IDX             = 0,
    AXGE_IFACE_IDX              = 0,
};


enum
{
    AXGE_RXHDR_L4_TYPE_MASK     = 0x1c,
    AXGE_RXHDR_L4CSUM_ERR       = 1,
    AXGE_RXHDR_L3CSUM_ERR       = 2,
    AXGE_RXHDR_L4_TYPE_UDP      = 4,
    AXGE_RXHDR_L4_TYPE_TCP      = 16,
};

enum
{
    AXGE_RXHDR_CRC_ERR          = 0x2000,
    AXGE_RXHDR_DROP_ERR         = 0x8000,
};

enum
{
    AXGE_FLAG_LINK              = 0x0001,
};

}}}}
