﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   Power clock management for ethernet driver
 * @detail  Files in 'pcv.stub' are tentative.
 *          These files will be moved to 'Programs/Eris/Sources/Libraries/pcv'
 *          after pcv process is implemented for Tegra X2.
 */

#pragma once

#include <nn/nn_Common.h>

#if defined(NN_BUILD_CONFIG_SOC_TEGRA_X2)
#include "eth_Pcv.tegra-x2.h"
#else
#error "Unsupported hardware."
#endif

namespace nn     {
namespace eth    {
namespace device {
namespace tx2    {
namespace pcv    {

typedef uint32_t ClockHz;

void Initialize() NN_NOEXCEPT;
nn::Result SetReset(Module moduleId, bool asserted) NN_NOEXCEPT;
nn::Result SetClockEnabled(Module moduleId, bool enabled) NN_NOEXCEPT;
Result SetClockRate(Module moduleId, ClockHz clockRateHz) NN_NOEXCEPT;

}}}}}
