﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/result/result_HandlingUtility.h>

#include "../eth_Allocator.h"
#include "eth_Tx2Main.h"
#include "eth_SynopsysDwcEtherQos.h"

namespace {

const uint32_t InterfaceCount = 1;

nn::eth::device::tx2::SynopsysDwcEtherQos g_Device;
bool g_Initialized = false;

}

namespace nn     {
namespace eth    {
namespace device {
namespace tx2    {

uint32_t GetInterfaceCount() NN_NOEXCEPT
{
    return InterfaceCount;
}

nn::Result Initialize() NN_NOEXCEPT
{
    NN_SDK_ASSERT(g_Initialized == false, "nn::eth::device::tx2 does not support multiple initialization.\n");
    g_Initialized = true;

    NN_RESULT_DO(g_Device.Initialize());

    return nn::ResultSuccess();
}

}}}}
