﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/os/os_MemoryAttribute.h>
#include <nn/nn_Result.h>
#include <nn/eth/eth_Result.h>

#include "eth_Allocator.h"

namespace nn     {
namespace eth    {
namespace device {

class Packet :
    public Allocator
{
public:
    size_t    m_TotalLength;
    size_t    m_ValidLength;
    uint8_t*  m_pData;
    uint32_t  m_Id;

    Packet()
    NN_NOEXCEPT :
        m_pData(nullptr)
    {

    }

    ~Packet()
    NN_NOEXCEPT
    {
        Finalize();
    }

    nn::Result Initialize(size_t packetSize)
    NN_NOEXCEPT
    {
        m_pData = (uint8_t*)lmem::AllocateFromExpHeap(g_HeapHandle, packetSize, nn::os::MemoryPageSize);

        if (m_pData == nullptr)
        {
            return ResultOutOfMemory();
        }

        m_TotalLength = packetSize;
        m_ValidLength = 0;

        return ResultSuccess();
    }

    void Finalize()
    {
        if (m_pData != nullptr)
        {
            lmem::FreeToExpHeap(g_HeapHandle, m_pData);
            m_pData = nullptr;
        }
    }
};

}}}
