﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

#include "dt_FdtReader.h"

namespace nn { namespace dt { namespace server {

class FdtManager
{
public:
    FdtManager() NN_NOEXCEPT : m_Initialized(false)
    {
    }

    void Initialize(const nn::Bit8* pFdt, size_t size) NN_NOEXCEPT;

    FdtReader* GetFdtReader() NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_Initialized);
        return &m_FdtReader;
    }

private:
    FdtReader m_FdtReader;
    bool m_Initialized;
};

FdtManager* GetFdtManager() NN_NOEXCEPT;

}}}
