﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include "dt_FdtManager.h"
#include "dt_FdtStorage.h"

namespace nn { namespace dt { namespace server {

extern const void* g_FdtBegin;
extern const void* g_FdtEnd;

void FdtManager::Initialize(const nn::Bit8* pFdt, size_t size) NN_NOEXCEPT
{
    if (pFdt == nullptr)
    {
        pFdt = GetFdtStoragePointer();
        size = GetFdtStorageSize();
    }

    m_FdtReader.Initialize(pFdt, size);

    m_Initialized = true;
    return;
}

FdtManager* GetFdtManager() NN_NOEXCEPT
{
    static FdtManager fdtManager;
    return &fdtManager;
}

}}}
