﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace drivers { namespace eth {

enum RegisterOffsets
{
    MAC0_OFFSET                     = 0,
    MAC4_OFFSET                     = 4,
    MAR0_OFFSET                     = 8,
    COUNTER_ADDR_LOW_OFFSET         = 0x10,
    COUNTER_ADDR_HIGH_OFFSET        = 0x14,
    TXDESC_START_ADDR_LOW_OFFSET    = 0x20,
    TXDESC_START_ADDR_HIGH_OFFSET   = 0x24,
    TXHDESC_START_ADDR_LOW_OFFSET   = 0x28,
    TXHDESC_START_ADDR_HIGH_OFFSET  = 0x2c,
    FLASH_OFFSET                    = 0x30,
    ERSR_OFFSET                     = 0x36,
    CHIP_CMD_OFFSET                 = 0x37,
    TX_POLL_OFFSET                  = 0x38,
    INTR_MASK_OFFSET                = 0x3C,
    INTR_STATUS_OFFSET              = 0x3E,
    TX_CONFIG_OFFSET                = 0x40,
    RX_CONFIG_OFFSET                = 0x44,
    TCTR_OFFSET                     = 0x48,
    RX_MISSED_OFFSET                = 0x4C,
    CFG9346_OFFSET                  = 0x50,
    CONFIG0_OFFSET                  = 0x51,
    CONFIG1_OFFSET                  = 0x52,
    CONFIG2_OFFSET                  = 0x53,
    CONFIG3_OFFSET                  = 0x54,
    CONFIG4_OFFSET                  = 0x55,
    CONFIG5_OFFSET                  = 0x56,
    TIME_INT0_OFFSET                = 0x58,
    TIME_INT1_OFFSET                = 0x5C,
    PHYAR_OFFSET                    = 0x60,
    TBICSR_OFFSET                   = 0x64,
    TBI_ANAR                        = 0x68,
    TBI_LPAR                        = 0x6A,
    PHY_STATUS_OFFSET               = 0x6C,
    ERIDR_OFFSET                    = 0x70,
    ERIAR_OFFSET                    = 0x74,
    TIME_INT2_OFFSET                = 0x8C,
    PHYOCP_OFFSET                   = 0xB8,
    MCU_CMD_OFFSET                  = 0xD3,
    RX_MAX_SIZE_OFFSET              = 0xDA,
    CPLUS_CMD_OFFSET                = 0xE0,
    RX_DESC_START_ADDR_LOW_OFFSET   = 0xE4,
    RX_DESC_START_ADDR_HIGH_OFFSET  = 0xE8,
    EARLY_TX_THRESH_OFFSET          = 0xEC,
    FUNC_EVENT_OFFSET               = 0xF0,
    FUNC_EVENT_MASK_OFFSET          = 0xF4,
    TIME_INT3_OFFSET                = 0xF4,
    FUNC_PRESET_STATE_OFFSET        = 0xF8,
    FUNC_FORCE_EVENT_OFFSET         = 0xFC,
};

enum Parameters
{
    TX_FIFO_THRESH      = 256,     /* In bytes */
    RX_FIFO_THRESH      = 7,       /* 7 means NO threshold, Rx buffer level before first PCI xfer.  */
    TX_DMA_BURST        = 6,       /* Maximum PCI burst, '6' is 1024 */
    EARLY_TX_THLD       = 0x3F,    /* 0x3F means NO early transmit */
    INTER_FRAME_GAP     = 0x03,    /* 3 means INTER_FRAME_GAP = the shortest one */
    REALTEK_MAC_DMA_ALIGNMENT_SIZE  = 256,
};

enum RegisterValues
{
    /* Interrupt Status Bits */
    SYS_ERR_INT_MASK                 = 0x8000,
    PCS_TIMEOUT_INT_MASK             = 0x4000,
    SWINT_INT_MASK                   = 0x0100,
    TX_DESC_UNAVAILABLE_INT_MASK     = 0x0080,
    RX_FIFO_OVERFLOW_INT_MASK        = 0x0040,
    LINK_CHANGE_INT_MASK             = 0x0020,
    RX_DESC_UNAVAILABLE_INT_MASK     = 0x0010,
    TX_ERR_INT_MASK                  = 0x0008,
    TX_OK_INT_MASK                   = 0x0004,
    RX_ERR_INT_MASK                  = 0x0002,
    RX_OK_INT_MASK                   = 0x0001,

    /* DMA Descriptor Bits */
    RXBOVF_MASK         = (1 << 24),
    RXFOVF_MASK         = (1 << 23),
    RXRWT_MASK          = (1 << 22),
    RXRES_MASK          = (1 << 21),
    RXRUNT_MASK         = (1 << 20),
    RXCRC_MASK          = (1 << 19),
    DESC_OWN_MASK       = (1 << 31), /* Descriptor is owned by NIC */
    RING_END_MASK       = (1 << 30), /* End of descriptor ring */
    FIRST_FRAGMENT_MASK = (1 << 29), /* First segment of a packet */
    LAST_FRAGMENT_MASK  = (1 << 28), /* Final segment of a packet */

    /* Chip Cmd Bits */
    CMD_RESET_MASK          = 0x10,
    CMD_RX_ENABLE_MASK      = 0x08,
    CMD_TX_ENABLE_MASK      = 0x04,
    CMD_RX_BUF_EMPTY_MASK   = 0x01,

    /* Cfg9346 Bits */
    CFG9346_LOCK_MASK       = 0x00,
    CFG9346_UNLOCK_MASK     = 0xC0,

    /* Dump Counter Command */
    COUNTER_DUMP_MASK       = 0x8,

    /* RX Config */
    RX_CONFIG_ACCEPT_ERR_MASK       = 0x20,
    RX_CONFIG_ACCEPT_RUNT_MASK      = 0x10,
    RX_CONFIG_ACCEPT_BROADCAST_MASK = 0x08,
    RX_CONFIG_ACCEPT_MULTICAST_MASK = 0x04,
    RX_CONFIG_ACCEPT_MY_PHYS_MASK   = 0x02,
    RX_CONFIG_ACCEPT_ALL_MASK       = 0x01,

    /* Transmit Priority Polling*/
    HPQ_MASK = 0x80,
    NPQ_MASK = 0x40,

    /* RxConfigBits */
    RX_CONFIG_FIFO_SHIFT            = 13,
    RX_CONFIG_DMA_SHIFT             = 8,
    RX_CONFIG_128_INT_EN_MASK       = (1 << 15),
    RX_CONFIG_FET_MULTI_EN_MASK     = (1 << 14),
    RX_CONFIG_HALF_REFETCH_MASK     = (1 << 13),
    RxCfg_9356SEL_MASK              = (1 << 6),
    RX_EARLY_OFF_V2_MASK            = (1 << 11),
    RX_EARLY_OFF_MASK               = 0x3800,
    RX_SINGLE_FETCH_V2_MASK         = (1 << 14),
    TX_DMA_BURST_UNLIMITED_MASK     = 7,

    /*Tx Config Bits */
    TX_INTER_FRAME_GAP_SHIFT  = 24,
    TX_DMA_SHIFT              = 8,
    TX_CFG_HWREV_MASK         = 0x7CC00000,
    TX_CFG_HWREV_8168E        = 0x2C000000,
    TX_CFG_HWREV_8168E_VL     = 0x2C800000,
    TX_CFG_HWREV_8168G        = 0x4C000000,

    /*rtl8169 PHY Status */
    TBI_ENABLE_MASK     = 0x80,
    TX_FLOW_CTRL_MASK   = 0x40,
    RX_FLOW_CTRL_MASK   = 0x20,
    SPEED_1000BPS_MASK  = 0x10,
    SPEED_100BPS_MASK   = 0x08,
    SPEED_10BPS_MASK    = 0x04,
    LINK_STATUS_MASK    = 0x02,
    FULL_DUPLEX_MASK    = 0x01,

    /* OCP GPHY access */
    OCPDR_WRITE           = 0x80000000,
    OCPDR_READ            = 0x00000000,
    OCPDR_REG_MASK        = 0xFF,
    OCPDR_DATA_MASK       = 0xFFFF,
    OCPDR_GPHY_REG_SHIFT  = 16,
    OCPAR_FLAG_MASK       = 0x80000000,
    OCPAR_GPHY_WRITE_MASK = 0x8000F060,
    OCPAR_GPHY_READ_MASK  = 0x0000F060,
    OCPR_WRITE_MASK       = 0x80000000,
    OCPR_READ_MASK        = 0x00000000,
    OCPR_ADDR_REG_SHIFT   = 16,
    OCPR_FLAG_MASK        = 0x80000000,
    OCP_STD_PHY_BASE_PAGE = 0x0A40,

    /* ERI access */
    ERIAR_FLAG_MASK     = 0x80000000,
    ERIAR_WRITE_MASK    = 0x80000000,
    ERIAR_READ_MASK     = 0x00000000,
    ERIAR_ADDR_ALIGN    = 4,
    ERIAR_EXGMAC_MASK   = 0,
    ERIAR_MSIX_MASK     = 1,
    ERIAR_ASF_MASK      = 2,
    ERIAR_OO_MASK       = 2,
    ERIAR_TYPE_SHIFT    = 16,
    ERIAR_BYTE_EN_MASK  = 0x0f,
    ERIAR_BYTE_EN_SHIFT = 12,
};

struct TxDMADesc
{
    uint32_t status;
    uint32_t vlan_tag;
    uint64_t addr;
};

struct RxDMADesc
{
    uint32_t status;
    uint32_t vlan_tag;
    uint64_t addr;
};

struct CountersDMADesc
{
    uint64_t tx_packets;
    uint64_t rx_packets;
    uint64_t tx_errors;
    uint32_t rx_errors;
    uint16_t rx_missed;
    uint16_t align_errors;
    uint32_t tx_one_collision;
    uint32_t tx_multi_collision;
    uint64_t rx_unicast;
    uint64_t rx_broadcast;
    uint32_t rx_multicast;
    uint16_t tx_aborted;
    uint16_t tx_underun;
};


} // namespace pci
} // namespace drivers
} // namespace nn

