﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/drivers/eth/driverEth.h>

namespace nn { namespace drivers { namespace eth {

nn::Result Initialize()
{
    return ResultSuccess();
}

nn::Result Finalize()
{
    return ResultSuccess();
}

void RegisterFrameReceivedCallBack(FrameReceivedCallBack callBack)
{
    NN_UNUSED(callBack);
}

void UnregisterFrameReceivedCallBack()
{
}

void RegisterSendCompletedCallBack(SendCompletedCallBack callBack)
{
    NN_UNUSED(callBack);
}

void UnregisterSendCompletedCallBack()
{
}

nn::Result GetMacAddress(uint8_t pMacAddress[NN_NET_MAC_ADDRESS_SIZE])
{
    std::memset(pMacAddress, 0, NN_NET_MAC_ADDRESS_SIZE);
    return ResultSuccess();
}

nn::Result Send(const void* frameData, int frameBytes)
{
    NN_UNUSED(frameData);
    NN_UNUSED(frameBytes);

    return ResultSuccess();
}

nn::Result Send(nnnetOslMbuf* pMbuf)
{
    NN_UNUSED(pMbuf);

    return ResultSuccess();
}

nn::Result Send(int32_t numSegments, uint8_t **segmentBuffers, size_t *segmentSizes)
{
    return nn::os::ResultNotImplemented();
}

void RegisterInterfaceStateCallBack(InterfaceStateCallBack callback)
{
}

void UnregisterInterfaceStateCallBack()
{
}

}}}
