﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/diag/diag_AbortTypes.h>
#include <nn/diag/diag_LogTypes.h>
#include <nn/diag/detail/diag_DetailAssert.h>

#include "detail/diag_Abort.h"

// macro.h に記述されている NN_UNEXPECTED_DEFAULT の実装です。
// diag ライブラリに含めておきます。
NN_NORETURN void nn::detail::UnexpectedDefaultImpl(
    const char* functionName,
    const char* fileName,
    int lineNumber) NN_NOEXCEPT
{
    std::va_list args;
    const diag::LogMessage message = {"", &args};
    const diag::AbortInfo abortInfo = {
        diag::AbortReason_UnexpectedDefault,
        &message,
#if defined(NN_DETAIL_ENABLE_ABORT_MESSAGE)
        "unexpected value passed to switch statement",
#else // defined(NN_DETAIL_ENABLE_ABORT_MESSAGE)
        "",
#endif // defined(NN_DETAIL_ENABLE_ABORT_MESSAGE)
        functionName,
        fileName,
        lineNumber
    };
    nn::diag::detail::InvokeAbortObserver(abortInfo);
    nn::diag::detail::Abort(nullptr);
}
