﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace diag { namespace detail {

/*!
    @brief      DbgHelp の使用の排他を開始します。

    @details
                DbgHelp は複数スレッドから同時に使用できないため、使用時には排他が必要です。
*/
void LockDbgHelpMutex() NN_NOEXCEPT;

/*!
    @brief      DbgHelp の使用の排他を終了します。

    @details
                DbgHelp は複数スレッドから同時に使用できないため、使用時には排他が必要です。
*/
void UnlockDbgHelpMutex() NN_NOEXCEPT;

}}} // nn::diag::detail
