﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Windows.h>
#include <nn/os/os_SdkMutex.h>
#include "diag_DbgHelp.h"

#if !defined (NN_BUILD_CONFIG_OS_WIN)
    #error "未サポートの OS 種別が指定されています。"
#endif

// SIGLO-21432: DbgHelp.h を VS2015 でビルドすると警告が出るので、抑制する。
#pragma warning(push)
#pragma warning(disable: 4091)
#include <DbgHelp.h>
#pragma warning(pop)

#pragma comment(lib, "DbgHelp.lib")

namespace nn { namespace diag { namespace detail {

class DbgHelpInitializer
{
public:
    DbgHelpInitializer()
    {
        SymSetOptions(SYMOPT_UNDNAME | SYMOPT_DEFERRED_LOADS);
        SymInitialize(GetCurrentProcess(), NULL, true);
    }
};

namespace
{
    os::SdkMutexType g_DbgHelpMutex = NN_OS_SDK_MUTEX_INITIALIZER();
}

void LockDbgHelpMutex() NN_NOEXCEPT
{
    NN_FUNCTION_LOCAL_STATIC(DbgHelpInitializer, s_Initializer);
    g_DbgHelpMutex.Lock();
}

void UnlockDbgHelpMutex() NN_NOEXCEPT
{
    g_DbgHelpMutex.Unlock();
}

}}} // nn::diag::detail
