﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/dd/dd_PhysicalAddress.h>
#include <nn/svc/svc_Base.h>

namespace nn { namespace dd { namespace detail {

//-----------------------------------------------------------------------------

uintptr_t QueryIoMappingAddressImpl(PhysicalAddress physicalAddress, size_t size) NN_NOEXCEPT;

//-----------------------------------------------------------------------------

inline Bit32 ReadIoRegisterImpl(PhysicalAddress physicalAddress) NN_NOEXCEPT
{
    Bit32 data;
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::svc::ReadWriteRegister(&data, physicalAddress, 0, 0));
    return data;
}

inline void WriteIoRegisterImpl(PhysicalAddress physicalAddress, Bit32 value) NN_NOEXCEPT
{
    Bit32 data;
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::svc::ReadWriteRegister(&data, physicalAddress, 0xffffffff, value));
    NN_UNUSED(data);
}

inline Bit32 ReadModifyWriteIoRegisterImpl(PhysicalAddress physicalAddress, Bit32 value, Bit32 mask) NN_NOEXCEPT
{
    Bit32 data;
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::svc::ReadWriteRegister(&data, physicalAddress, mask, value));
    return data;
}

//-----------------------------------------------------------------------------

}}} // namespace nn::dd::detail

