﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_SdkText.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Dd.h>
#include <nn/svc/svc_Result.h>

#include "dd_IoMappingAddressImpl-os.horizon.h"

namespace nn { namespace dd { namespace detail {

//-----------------------------------------------------------------------------

uintptr_t QueryIoMappingAddressImpl(PhysicalAddress physicalAddress, size_t size) NN_NOEXCEPT
{
    // アライメントされていない physicalAddress や size でも svc に渡せる
    uintptr_t   virtualAddress;
    auto result = svc::QueryIoMapping(&virtualAddress, physicalAddress, size);

    NN_RESULT_TRY(result)
        NN_RESULT_CATCH( svc::ResultNotFound )
        {
            // 該当物理アドレスがマッピングされていない場合は NULL を返す
            return 0;
        }
        NN_RESULT_CATCH_ALL
        {
            NN_SDK_LOG(NN_TEXT("I/O 空間のマッピング先アドレス情報取得に失敗しました。\n"));
            NN_SDK_LOG("  physicalAddress=0x%016llx, size=0x%p\n", physicalAddress, size);
            NN_ABORT_UNLESS_RESULT_SUCCESS(result);
        }
    NN_RESULT_END_TRY

    return virtualAddress;
}

//-----------------------------------------------------------------------------

}}} // namespace nn::dd::detail

