﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Compiler.h>
#if defined(NN_BUILD_CONFIG_COMPILER_VC)
    #pragma warning( disable : 4566 )
#endif

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/dd/dd_Result.h>

#include <nn/nn_Windows.h>

namespace nn { namespace dd { namespace detail {

//-----------------------------------------------------------------------------

class DeviceAddressSpaceImplByWin32
{
public:
    static Result Create(DeviceAddressSpaceHandle*, uint64_t, uint64_t) NN_NOEXCEPT
    {
        return nn::dd::ResultNotSupported();
    }

    static void   Close(DeviceAddressSpaceHandle) NN_NOEXCEPT
    {
    }

    static Result MapAligned(DeviceAddressSpaceHandle, ProcessHandle, uint64_t, size_t, DeviceVirtualAddress, nn::dd::MemoryPermission) NN_NOEXCEPT
    {
        return nn::dd::ResultNotSupported();
    }

    static Result MapNotAligned(DeviceAddressSpaceHandle, ProcessHandle, uint64_t, size_t, DeviceVirtualAddress, nn::dd::MemoryPermission) NN_NOEXCEPT
    {
        return nn::dd::ResultNotSupported();
    }

    static Result MapPartially(size_t*, DeviceAddressSpaceHandle, ProcessHandle, uint64_t, size_t, DeviceVirtualAddress, nn::dd::MemoryPermission) NN_NOEXCEPT
    {
        return nn::dd::ResultNotSupported();
    }

    static void   Unmap(DeviceAddressSpaceHandle, ProcessHandle, uint64_t, size_t, DeviceVirtualAddress) NN_NOEXCEPT
    {
    }

    static Result Attach(DeviceAddressSpaceType*, DeviceName) NN_NOEXCEPT
    {
        return nn::dd::ResultNotSupported();
    }

    static void   Detach(DeviceAddressSpaceType*, DeviceName) NN_NOEXCEPT
    {
    }
};

typedef DeviceAddressSpaceImplByWin32 DeviceAddressSpaceImpl;

//-----------------------------------------------------------------------------

}}} // namespace nn::dd::detail

