﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/dd/dd_Macro.h>
#include <nn/dd/dd_PhysicalAddress.h>

#include <nnc/result/result_CConverter.h>
#include <nnc/dd/dd_Macro.h>
#include <nnc/dd/dd_PhysicalAddress.h>

//---------------------------------------------------------------------------
//  C++ 用の型とサイズやアライメント、定数値等が一致しているのかをチェック
//---------------------------------------------------------------------------

static_assert(sizeof(nnddPhysicalMemoryInfo) == sizeof(nn::dd::PhysicalMemoryInfo), "");
static_assert(offsetof(nnddPhysicalMemoryInfo, physicalAddress) == offsetof(nn::dd::PhysicalMemoryInfo, physicalAddress), "");
static_assert(offsetof(nnddPhysicalMemoryInfo, virtualAddress) == offsetof(nn::dd::PhysicalMemoryInfo, virtualAddress), "");
static_assert(offsetof(nnddPhysicalMemoryInfo, size) == offsetof(nn::dd::PhysicalMemoryInfo, size), "");
static_assert(offsetof(nnddPhysicalMemoryInfo, _endVirtualAddress) == offsetof(nn::dd::PhysicalMemoryInfo, _endVirtualAddress), "");
static_assert(NN_ALIGNOF(nnddPhysicalMemoryInfo) == NN_ALIGNOF(nn::dd::PhysicalMemoryInfo), "");

NN_DD_EXTERN_C void nnddInitializePhysicalMemoryInfo( nnddPhysicalMemoryInfo* pOutInfo, const void* addr, size_t size )
{
    nn::dd::InitializePhysicalMemoryInfo(reinterpret_cast<nn::dd::PhysicalMemoryInfo*>(pOutInfo), addr, size);
}

NN_DD_EXTERN_C nnResult nnddQueryNextPhysicalMemoryInfo( nnddPhysicalMemoryInfo* pOutInfo )
{
    nn::Result result = nn::dd::QueryNextPhysicalMemoryInfo(reinterpret_cast<nn::dd::PhysicalMemoryInfo*>(pOutInfo));
    return nn::result::ConvertToC(result);
}

NN_DD_EXTERN_C nnResult nnddQuerySinglePhysicalAddress( nnddPhysicalAddress* pOut, const void* addr, size_t size )
{
    nn::Result result = nn::dd::QuerySinglePhysicalAddress(reinterpret_cast<nn::dd::PhysicalAddress*>(pOut), addr, size);
    return nn::result::ConvertToC(result);
}

