﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/dd/dd_PhysicalAddress.h>

#include "detail/dd_IoMappingAddressImpl.h"

namespace nn { namespace dd {

uintptr_t QueryIoMappingAddress(PhysicalAddress physicalAddress, size_t size) NN_NOEXCEPT
{
    return detail::QueryIoMappingAddressImpl(physicalAddress, size);
}

Bit32 ReadIoRegister(PhysicalAddress physicalAddress) NN_NOEXCEPT
{
    return detail::ReadIoRegisterImpl(physicalAddress);
}

void WriteIoRegister(PhysicalAddress physicalAddress, Bit32 value) NN_NOEXCEPT
{
    detail::WriteIoRegisterImpl(physicalAddress, value);
}

Bit32 ReadModifyWriteIoRegister(PhysicalAddress physicalAddress, Bit32 value, Bit32 mask) NN_NOEXCEPT
{
    return detail::ReadModifyWriteIoRegisterImpl(physicalAddress, value, mask);
}

}}  // namespace nn::dd

