﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_ExpHeapAllocator.h>

#include <nn/spl/spl_Api.h>
#include <nn/spl/detail/spl_RandomInterface.h>

#include <nn/nn_Abort.h>
#include <nn/os.h>
#include <mutex>

namespace nn { namespace crypto {

    namespace
    {
        struct AllocatorTag
        {
        };

        typedef nn::sf::ExpHeapStaticAllocator<1024, AllocatorTag> MyAllocator;

        nn::sf::SharedPointer<nn::spl::detail::IRandomInterface> g_Ref;
        bool        g_IsInitialized = false;
        os::Mutex   g_Lock(false);

    }
    // anonymouse namespace


    void InitializeCsrng()
    {
        NN_SDK_ASSERT( ! g_IsInitialized );

        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);

        Result result = nn::sf::CreateHipcProxyByName<
            nn::spl::detail::IRandomInterface, MyAllocator::Policy>(
                &g_Ref, nn::spl::detail::PortNameRandom);

        NN_ABORT_UNLESS_RESULT_SUCCESS( result );
    }

    void GenerateCryptographicallyRandomBytes(
        void*   pOutBuffer,
        size_t  bufferSize ) NN_NOEXCEPT
    {
        {
            std::lock_guard<os::Mutex> lock(g_Lock);

            if( ! g_IsInitialized )
            {
                InitializeCsrng();
                g_IsInitialized = true;
            }
        }

        NN_ABORT_UNLESS_RESULT_SUCCESS(
            g_Ref->GenerateRandomBytes(
                sf::OutBuffer(reinterpret_cast<char*>(pOutBuffer), bufferSize) ));
    }



}}  // namespace nn::crypto
