﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief DHCP client internal utilities
 *
 * @details
 */

namespace nn { namespace bsdsocket { namespace dhcpc {

class Util
{
public:
    struct ToABuffer
    {
        char data[64];
    };
    enum LogLevel
    {
        LogLevel_Verbose = 0,
        LogLevel_Info,
        LogLevel_Warn,
        LogLevel_Error,
        LogLevel_Max,
    };
    static const char * LogLevelNames[LogLevel_Max];

    static const char* HwAddrToA(const unsigned char *hwaddr, size_t hwlen, ToABuffer *buf);
    static const char* GetDhcpProtMsgTypeDescription(DhcpProtMsgType t);
    static void Log(LogLevel severity, const char *format, ...);
    static void GetSaturatedUpTimeSeconds(uint16_t *pRetVal);
    static void GetUpTime(TimeSpan *pRetVal);
    static size_t EncodeRfc1035(const char *src, uint8_t *dst);
    static uint16_t Checksum(const uint8_t *data, uint16_t len);
    static void GetAddrs(int type, char *cp, struct sockaddr **sa);

    static const uint8_t* GetOption(uint8_t optionBuffer[DhcpSizes_Option + DhcpSizes_Bootfile + DhcpSizes_ServerName],
                                    const DhcpMessage *dhcp, uint32_t opt, size_t *len);
    static int32_t GetOptionAddr(uint8_t optionBuffer[DhcpSizes_Option + DhcpSizes_Bootfile + DhcpSizes_ServerName],
                                 in_addr_t *a, const DhcpMessage *dhcp, uint8_t option);
    static int32_t GetOptionUint32(uint8_t optionBuffer[DhcpSizes_Option + DhcpSizes_Bootfile + DhcpSizes_ServerName],
                                   uint32_t *i, const DhcpMessage *dhcp, uint8_t option);
    static int32_t GetOptionUint8(uint8_t optionBuffer[DhcpSizes_Option + DhcpSizes_Bootfile + DhcpSizes_ServerName],
                                  uint8_t *i, const DhcpMessage *dhcp, uint8_t option);

    // Lease management
    static void GetLeaseFromDhcpMessage(uint8_t *pOptionBuffer, Lease *pReturnedLease, DhcpMessage *dhcp);
    static bool ApplyLeaseLimits(Lease *pLease);

    // IPV4
    static uint32_t Ipv4GetNetmask(uint32_t addr);
    // Log warning level
    static LogLevel m_LogLevel;
};

} // namespace dhcpc
} // namespace bsdsocket
} // namespace nn

