﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Internal macros
 *
 * @details
 */

#pragma once

namespace nn { namespace bsdsocket { namespace dhcpc {

// Log macros
#define DHCPC_ABORT(format,...)            NN_ABORT(format, ##__VA_ARGS__)
#define DHCPC_ABORT_UNLESS_SUCCESS(result) NN_ABORT_UNLESS((result).IsSuccess())
#define DHCPC_ABORT_NULL(pointerVal)       NN_ABORT_UNLESS_NOT_NULL(pointerVal)
#define DHCPC_LOG_VERBOSE(format,...)      Util::Log(Util::LogLevel_Verbose, format, ##__VA_ARGS__)
#define DHCPC_LOG_INFO(format,...)         Util::Log(Util::LogLevel_Info, format, ##__VA_ARGS__)
#define DHCPC_LOG_WARN(format,...)         Util::Log(Util::LogLevel_Warn, format, ##__VA_ARGS__)
#define DHCPC_LOG_ERROR(format,...)        Util::Log(Util::LogLevel_Error, format, ##__VA_ARGS__)
#define DHCPC_LOG_NOPREFIX(format,...)     NN_SDK_LOG(format, ##__VA_ARGS__)

// Error handling macros
#define DHCPC_BREAK_UPON_ERROR(attemptedMethodCall)                                  \
    if (!((result=(attemptedMethodCall)).IsSuccess()))                               \
    {                                                                                \
        DHCPC_LOG_WARN("file-%s, line-%d, call to %s failed, handled with break.\n", \
                     __FILE__,__LINE__,#attemptedMethodCall);  break;                \
    }

#define DHCPC_RETURN_UPON_ERROR(attemptedMethodCall)                                 \
    if (!((result=(attemptedMethodCall)).IsSuccess()))                               \
    {                                                                                \
        DHCPC_LOG_WARN("file-%s, line-%d, call to %s failed, handled with return.\n",\
                     __FILE__,__LINE__,#attemptedMethodCall);  return result;        \
    }

#define DHCPC_COMPARE_RESULT(a, b)  \
    ((((a).GetInnerValueForDebug()) == ((b).GetInnerValueForDebug())) ? true : false)

#define DHCPC_MIN(a, b)   (((a) < (b)) ? (a) : (b))
#define DHCPC_MAX(a, b)   (((a) > (b)) ? (a) : (b))

#define DHCPC_PUTADDR(_type, _val)                              \
    {                                                           \
        in_addr_t _addr = reinterpret_cast<in_addr_t>(_val);    \
        *p++ = _type;                                           \
        *p++ = 4;                                               \
        memcpy(p, &_addr, 4);                                   \
        p += 4;                                                 \
    }


} // namespace dhcpc
} // namespace bsdsocket
} // namespace nn


