﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief External request deferral
 *
 * @details This class handles deferment of external API
 *          requests
 */

#pragma once

#include "dhcpc_PrivateIncludes.h"

namespace nn { namespace bsdsocket { namespace dhcpc {

class DeferredRequest
{
public:
    enum Command
    {
        Command_Invalid = 0,
        Command_Initialize,
        Command_StopIf,
        Command_FinalizeIf,
        Command_GetState,
        Command_GetOptionData,
        Command_ForceRenew,
    };
    union Params
    {
        struct
        {
            const InterfaceConfigType *pIfConfig;
        }initialize;
        struct
        {
            char     *pReturnedStateName;
            size_t   stateNameSizeLimit;
        }getState;
        struct
        {
            const char     *pStateName;
            size_t          stateNameSize;
        }setState;
        struct
        {
            DhcpProtOption  option;
            void            *pRetData;
            size_t          bufferSize;
            size_t          *pRetSize;
        }getOptionData;
        struct
        {
            uint32_t options;
        }stopIf;
    };

    Command  m_Command;
    int32_t  m_IfIndex;
    Result   m_Result;
    Params   m_Params;

    DeferredRequest(Command command, int32_t m_IfIndex)
        : m_Command(command)
        , m_IfIndex(m_IfIndex)
        , m_BlockedCallerSemaphore(0, 1)
    {
        m_Result = ResultSuccess();
        memset(&m_Params, 0, sizeof(m_Params));
    }

    ~DeferredRequest()
    {
    }
    Result BlockOnRequest()
    {
        m_BlockedCallerSemaphore.Acquire();
        return m_Result;
    }
    void CompleteRequest(Result status)
    {
        m_Result = status;
        m_BlockedCallerSemaphore.Release();
    }
private:
    nn::os::Semaphore m_BlockedCallerSemaphore;
};

} // namespace dhcpc
} // namespace bsdsocket
} // namespace nn

