﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.bsdsocket.cfg
{
    [CppRefPath(@"<nn/bsdsocket/cfg/cfg_Types.h>")]
    [ExternalStruct(44, 4)]
    public struct IfSettings
    {
    }

    [CppRefPath(@"<nn/bsdsocket/cfg/sfdl/cfg.sfdl.h>")]
    public interface ServerInterface : IServiceObject
    {
        [MethodId(0)]
        Result SetIfUp(nn.sf.InBuffer ifName, IfSettings ifSettings);

        [MethodId(1)]
        Result SetIfUpWithEvent(nn.sf.InBuffer ifName, IfSettings ifSettings, Out<NativeHandle> handleOut);

        [MethodId(2)]
        Result CancelIf(nn.sf.InBuffer ifName);

        [MethodId(3)]
        Result SetIfDown(nn.sf.InBuffer ifName, uint32_t options);

        [MethodId(4)]
        Result GetIfState(nn.sf.InBuffer ifName, nn.sf.OutBuffer ifState);

        [MethodId(5)]
        Result DhcpRenew(nn.sf.InBuffer ifName);

        [MethodId(6)]
        Result AddStaticArpEntry(uint32_t ipAddress, nn.sf.InBuffer hardwareAddress);

        [MethodId(7)]
        Result RemoveArpEntry(uint32_t ipAddress);

        [MethodId(8)]
        Result LookupArpEntry(nn.sf.OutBuffer outputHardwareAddress, uint32_t ipAddress);

        [MethodId(9)]
        Result LookupArpEntry2(nn.sf.OutBuffer outputIpAddress, nn.sf.InBuffer hardwareAddress);

        [MethodId(10)]
        Result ClearArpEntries();

        [MethodId(11)]
        Result ClearArpEntries2(nn.sf.InBuffer ifName);

        [MethodId(12)]
        Result PrintArpEntries();
    }
}
