﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Compiler.h>
#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>
#include "../kern_Platform.h"
#include "../kern_Panic.h"

extern "C" {

    void __rt_raise(int sig, int type)
    {
        NN_UNUSED(sig);
        NN_UNUSED(type);
        NN_KERNEL_PANIC("__rt_raise(sig=%d, type=%d)", sig, type);
    }

    void __aeabi_atexit()       {}
    void __cxa_atexit()         {}
    void __cxa_finalize()       {}
    void atexit()               {}
    void __funcs_on_exit()      {}
    void __init_alloc()         {}
    void __rt_SIGTMEM()         {}
    void __cxa_pure_virtual()   {}
    void __rt_div0()            {}
    void __cxa_guard_acquire()  {}
    void __cxa_guard_release()  {}

#if defined NN_BUILD_CONFIG_COMPILER_GCC
    void abort()
    {
        for (;;) {}
    }
#endif
}
