﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <nn/TargetConfigs/build_Cpu.h>

#if   defined(NN_BUILD_CONFIG_CPU_ARM)

#include "ip/ARM/kern_UserContext.h"
namespace nn { namespace kern {
    using ARM::GetUserContext;
    using ARM::GetUserStackPointer;
}}

#elif defined(NN_BUILD_CONFIG_CPU_ARM64)

#include "ip/ARM64/kern_UserContext.h"
namespace nn { namespace kern {
    using ARM64::GetUserContext;
    using ARM64::GetUserStackPointer;
}}

#else
#error no KContext is selected
#endif

