﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace kern {

    /*!
        @brief     プログラムの実行を停止します。
        @param[in]    filename     ファイル名
        @param[in]    lineno       行番号
        @param[in]    fmt          出力書式文字列(フォーマット文字列)

    */
    NN_NORETURN void Panic(const char* filename, int lineno, const char* fmt, ...);
    /*!
        @brief     プログラムの実行を停止します。停止位置の情報は表示されません。

    */
    NN_NORETURN void PanicQuietly();
}}

#ifdef NN_SWITCH_DISABLE_DEBUG_PRINT
#define NN_KERNEL_PANIC(...)    nn::kern::PanicQuietly()
#else
#define NN_KERNEL_PANIC(...)    nn::kern::Panic(__FILE__, __LINE__, __VA_ARGS__)
#endif

