﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*!
    @file

    @brief イベントに関する API の宣言

*/

#pragma once

#include <nn/nn_Common.h>
#include "kern_Assert.h"
#include "kern_KObjectAdaptor.h"
#include "kern_KAutoObject.h"

namespace nn { namespace kern {
class KEvent;

/*!
  @brief      イベント クラスの定義です。
*/
class KWritableEvent :
    public KObjectAdaptor<KWritableEvent, KAutoObjectWithList>
{
private:
    KEvent* m_pParentEvent;

public:
    explicit KWritableEvent() {}
    virtual ~KWritableEvent() {}
    void  Initialize(KEvent* pParentEvent);
    static void PostFinalize(uintptr_t arg) { NN_UNUSED(arg); }
    KEvent* GetParent() const { return m_pParentEvent; }

    virtual void Destroy();
    Result Signal();
    Result Clear();

    NN_AUTOOBJECT_DERIVED_FUNCSET(KWritableEvent, KAutoObject)
};

}}

