﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_Platform.h"
#include "kern_Assert.h"
#include "kern_Kernel.h"
#include "kern_KEvent.h"
#include "kern_KReadableEvent.h"
#include "kern_KWritableEvent.h"
#include "kern_KScopedSchedulingLock.h"

namespace nn { namespace kern {

NN_AUTOOBJECT_DEFINE_TYPE_NAME(KWritableEvent);

void KWritableEvent::Initialize(KEvent* pParentEvent)
{
    m_pParentEvent = pParentEvent;
    m_pParentEvent->GetReadableEvent().Open();
}

Result KWritableEvent::Signal()
{
    return m_pParentEvent->GetReadableEvent().Signal();
}

Result KWritableEvent::Clear()
{
    return m_pParentEvent->GetReadableEvent().Clear();
}

void KWritableEvent::Destroy()
{
    m_pParentEvent->GetReadableEvent().Close();
    m_pParentEvent->Close();
}

}}
