﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "kern_KRbTree.h"

namespace nn { namespace kern {

    class KTimerTask : public IntrusiveRbTreeBaseNode<KTimerTask>
    {
    private:
        int64_t     m_Time;

    public:
        KTimerTask() : m_Time(0) {}

        virtual void OnTimer() = 0;

        void SetTime(int64_t time)
        {
            m_Time = time;
        }

        int64_t GetTime() const
        {
            return m_Time;
        }
    };

}}

