﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "kern_KSimpleLock.h"
#include "kern_Assert.h"

namespace nn { namespace kern {
class KSpinLockMutex
{
private:
    KSimpleLock m_Lock;
    int32_t     m_Count;
    KThread*    m_pLockingThread;

public:
    KSpinLockMutex() :  m_Count(0), m_pLockingThread(nullptr)
    {
        NN_KERN_THIS_ASSERT();
    }

    void Lock();
    void Unlock();
    void UnlockAndScheduleAll();
    bool IsLockedByMe() const
    {
        NN_KERN_THIS_ASSERT();
        return m_pLockingThread == &GetCurrentThread();
    }
};

class KScopedSpinLock
{
private:
    KSpinLockMutex* m_Mutex;

public:

    //! コンストラクタ
    explicit KScopedSpinLock(KSpinLockMutex* mutex) : m_Mutex(mutex)
    {
        NN_KERN_THIS_ASSERT();
        m_Mutex->Lock();
    }

    //! デストラクタ
    ~KScopedSpinLock()
    {
        NN_KERN_THIS_ASSERT();
        m_Mutex->Unlock();
    }

};

}}

