﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_Platform.h"
#include "kern_Assert.h"
#include "kern_KSession.h"
#include "kern_KPort.h"
#include "kern_KProcess.h"

namespace nn { namespace kern {

NN_AUTOOBJECT_DEFINE_TYPE_NAME(KSession);

void KSession::Initialize(KClientPort* pPort, uintptr_t name)
{
    NN_KERN_THIS_ASSERT();
    // 参照カウンタを加算します。
    // こうしておくことで、生成時 + Initialze()の2つ分増えます。
    // (サーバーセッション、クライアントセッションの二つを持つため)
    Open();
    KAutoObject::Create(&m_ServerSession);
    KAutoObject::Create(&m_ClientSession);
    m_ServerSession.Initialize(this);
    m_ClientSession.Initialize(this);
    m_State = STATE_ACTIVE;
    m_Name = name;

    m_pOwner = GetCurrentProcessPointer();
    m_pOwner->Open();
    m_pPort = pPort;

    if( m_pPort != NULL )
    {
        m_pPort->Open();
    }
    m_IsInitialized = true;
}

void KSession::Finalize()
{
    if( m_pPort != NULL )
    {
        m_pPort->OnSessionFinalized();
        m_pPort->Close();
    }
}

//! サーバーセッションが閉じた際に呼ばれます
void KSession::OnServerClosed()
{
    NN_KERN_THIS_ASSERT();
    if( m_State == STATE_ACTIVE )
    {
        // クライアントセッションに対し、サーバーが閉じたことを通知します
        m_State = STATE_SERVER_CLOSED;
        m_ClientSession.OnServerClosed();
    }
}

//! クライアントセッションが閉じた際に呼ばれます
void KSession::OnClientClosed()
{
    NN_KERN_THIS_ASSERT();
    if( m_State == STATE_ACTIVE )
    {
        // サーバーセッションに対し、クライアントが閉じたことを通知します
        m_State = STATE_CLIENT_CLOSED;
        m_ServerSession.OnClientClosed();
    }
}

void KSession::PostFinalize(uintptr_t arg)
{
    KProcess* pOwner = reinterpret_cast<KProcess*>(arg);
    pOwner->ReleaseLimit(nn::svc::LimitableResource_SessionCountMax, 1);
    pOwner->Close();
}


}}
