﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_IntrusiveList.h>
#include "kern_KSynchronizationObject.h"
#include "kern_KThread.h"
#include "kern_KThreadQueue.h"
#include "kern_KSessionRequest.h"
#include "kern_KLightMutex.h"

namespace nn { namespace kern {

class KSession;

class KServerSession :
    public KSynchronizationObject,
    public nn::util::IntrusiveListBaseNode<KServerSession>
{
private:
    typedef nn::util::IntrusiveList<KSessionRequest, nn::util::IntrusiveListBaseNodeTraits<KSessionRequest>> RequestList;

    KSession*               m_pParent;                      //!< クライアントとサーバーの間を取り持つセッション
    RequestList             m_RequestQueue;
    KSessionRequest*        m_pCurrentRequest;
    KLightMutex             m_Lock;

public:
    explicit        KServerSession() : m_pCurrentRequest(nullptr) {}
    virtual         ~KServerSession() {}

    void            Initialize(KSession* p) { m_pParent = p; }

    virtual void    Destroy();
    virtual bool    IsSignaled() const;

    //! リクエストを受け取ったときの処理
    Result          ReceiveRequest(uintptr_t pMessage, size_t bufferSize);
    //! サーバーセッションからクライアントセッションに対してレスポンスを返します。
    //! serverThread は　CurrntThreadです。
    Result          SendReply(uintptr_t pMessage, size_t bufferSize);

    Result          OnRequest(KSessionRequest* pRequest);

    //! クライアントセッションが閉じたことの通知
    void            OnClientClosed();

    KSession*       GetParent() const { return m_pParent; }

    void            Dump();
private:
    void            CleanupRequest();
    bool            IsSignaledImpl() const;

    //! KAutoObjectのプリセット関数セット定義です。クラスの末尾に記述する必要があります
    NN_AUTOOBJECT_DERIVED_FUNCSET(KServerSession, KSynchronizationObject)
};

}}

