﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_IntrusiveList.h>
#include "kern_KSynchronizationObject.h"

namespace nn { namespace kern {

class KThread;
class KPort;
class KServerSession;
class KLightServerSession;

class KServerPort : public KSynchronizationObject
{
private:
    typedef nn::util::IntrusiveList<KServerSession, nn::util::IntrusiveListBaseNodeTraits<KServerSession>> SessionList;
    typedef nn::util::IntrusiveList<KLightServerSession, nn::util::IntrusiveListBaseNodeTraits<KLightServerSession>> LightSessionList;

    SessionList         m_SessionList;
    LightSessionList    m_LightSessionList;
    KPort*              m_pParent;

public:
    explicit        KServerPort() {}
    virtual         ~KServerPort() {}
    virtual void    Destroy();
    virtual bool    IsSignaled() const;
    bool            IsLight() const;

    void            Initialize(KPort* p);
    void            EnqueueSession(KServerSession* pSession);
    void            EnqueueSession(KLightServerSession* pSession);
    void            OnClientClosed();
    void            Cleanup();
    const KPort*    GetParent() const { return m_pParent; }

    KServerSession* AcceptSession();
    KLightServerSession* AcceptLightSession();

    NN_AUTOOBJECT_DERIVED_FUNCSET(KServerPort, KSynchronizationObject)
};


}}

