﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/svc/svc_Kernel.h>
#include "kern_KResourceLimit.h"
#include "kern_KProcess.h"

namespace nn { namespace kern {
class KScopedResourceLimitTester
{
private:
    KResourceLimit*             m_pLimit;
    nn::svc::LimitableResource  m_Resource;
    int64_t                     m_Value;
    bool                        m_Result;

public:
    KScopedResourceLimitTester(KProcess* pProcess, nn::svc::LimitableResource resource, int64_t value, int64_t timeout)
        : m_pLimit(pProcess->GetResourceLimit())
        , m_Resource(resource)
        , m_Value(value)
    {
        if (m_pLimit && m_Value)
        {
            m_Result = m_pLimit->TestLimit(m_Resource, m_Value, timeout);
        }
        else
        {
            m_Result = true;
        }
    }

    KScopedResourceLimitTester(KProcess* pProcess, nn::svc::LimitableResource resource, int64_t value)
        : m_pLimit(pProcess->GetResourceLimit())
        , m_Resource(resource)
        , m_Value(value)
    {
        if (m_pLimit && m_Value)
        {
            m_Result = m_pLimit->TestLimit(m_Resource, m_Value);
        }
        else
        {
            m_Result = true;
        }
    }

    KScopedResourceLimitTester(KProcess* pProcess, nn::svc::LimitableResource resource)
        : m_pLimit(pProcess->GetResourceLimit())
        , m_Resource(resource)
        , m_Value(1)
    {
        if (m_pLimit && m_Value)
        {
            m_Result = m_pLimit->TestLimit(m_Resource, m_Value);
        }
        else
        {
            m_Result = true;
        }
    }

    KScopedResourceLimitTester(KResourceLimit* pLimit, nn::svc::LimitableResource resource, int64_t value, int64_t timeout)
        : m_pLimit(pLimit)
        , m_Resource(resource)
        , m_Value(value)
    {
        if (m_pLimit && m_Value)
        {
            m_Result = m_pLimit->TestLimit(m_Resource, m_Value, timeout);
        }
        else
        {
            m_Result = true;
        }
    }

    KScopedResourceLimitTester(KResourceLimit* pLimit, nn::svc::LimitableResource resource, int64_t value)
        : m_pLimit(pLimit)
        , m_Resource(resource)
        , m_Value(value)
    {
        if (m_pLimit && m_Value)
        {
            m_Result = m_pLimit->TestLimit(m_Resource, m_Value);
        }
        else
        {
            m_Result = true;
        }
    }

    KScopedResourceLimitTester(KResourceLimit* pLimit, nn::svc::LimitableResource resource)
        : m_pLimit(pLimit)
        , m_Resource(resource)
        , m_Value(1)
    {
        if (m_pLimit && m_Value)
        {
            m_Result = m_pLimit->TestLimit(m_Resource, m_Value);
        }
        else
        {
            m_Result = true;
        }
    }

    ~KScopedResourceLimitTester()
    {
        if (m_pLimit && m_Result && m_Value)
        {
            m_pLimit->ReleaseLimit(m_Resource, m_Value);
        }
    }

    void Accepted()
    {
        m_pLimit = nullptr;
    }

    bool IsTestFailed() const
    {
        return !m_Result;
    }
};



}}

