﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include "kern_Platform.h"
#include "kern_Assert.h"
#include "kern_Kernel.h"
#include "kern_KPort.h"
#include "kern_KSynchronization.h"
#include "kern_KSession.h"
#include "kern_KScheduler.h"
#include "kern_KScopedSchedulingLock.h"

namespace nn { namespace kern {

NN_AUTOOBJECT_DEFINE_TYPE_NAME(KPort);


/* ------------------------------------------------------------------------
        初期化/破棄
   ------------------------------------------------------------------------ */

KPort::KPort(): m_State(STATE_INVALID), m_IsLight(false)
{
    NN_KERN_THIS_ASSERT();
}

KPort::~KPort()
{
    NN_KERN_THIS_ASSERT();
}

void KPort::Initialize(int32_t maxSessions, bool isLight, uintptr_t name)
{
    NN_KERN_THIS_ASSERT();

    Open();

    KAutoObject::Create(&m_Server);
    KAutoObject::Create(&m_Client);
    m_Server.Initialize(this);
    m_Client.Initialize(this, maxSessions);
    m_IsLight = isLight;
    m_Name = name;
    m_State = STATE_ACTIVE;
}


void KPort::OnServerClosed()
{
    NN_KERN_THIS_ASSERT();
    bool callClosed = false;

    {
        KScopedSchedulingLock locker;

        if (m_State == STATE_ACTIVE)
        {
            m_State = STATE_SERVER_CLOSED;
        }
    }

    if (callClosed)
    {
        m_Client.OnServerClosed();
    }
}

void KPort::OnClientClosed()
{
    NN_KERN_THIS_ASSERT();
    bool callClosed = false;

    {
        KScopedSchedulingLock locker;
        if (m_State == STATE_ACTIVE)
        {
            m_State = STATE_CLIENT_CLOSED;
        }
    }

    if (callClosed)
    {
        m_Server.OnClientClosed();
    }
}

Result KPort::EnqueueSession(KServerSession* pSession)
{
    KScopedSchedulingLock locker;
    if (m_State != STATE_ACTIVE)
    {
        return nn::svc::ResultPortClosed();
    }
    m_Server.EnqueueSession(pSession);
    return ResultSuccess();
}

Result KPort::EnqueueSession(KLightServerSession* pSession)
{
    KScopedSchedulingLock locker;
    if (m_State != STATE_ACTIVE)
    {
        return nn::svc::ResultPortClosed();
    }
    m_Server.EnqueueSession(pSession);
    return ResultSuccess();
}

}}

