﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include "kern_Platform.h"
#include "kern_Assert.h"
#include "kern_KAutoObject.h"
#include "kern_KObjectContainer.h"
#include "kern_Result.h"
#include "kern_KLightMutex.h"
#include "kern_Kernel.h"
#include "kern_KThread.h"


namespace nn { namespace kern {

//! コンストラクタ
KObjectContainer::KObjectContainer()
{
    NN_KERN_THIS_ASSERT();
}

//! デストラクタ
KObjectContainer::~KObjectContainer()
{
    NN_KERN_THIS_ASSERT();
    //残っている要素を解放
}

/*!
    @brief      コンテナにオブジェクトを登録します。

    @param[in]  pObj     対象のオブジェクト

    @return     常に成功を返します

*/
Result KObjectContainer::RegisterImpl(KAutoObjectWithList* pObj)
{
    NN_KERN_THIS_ASSERT();

    m_ObjectList.insert(*pObj);

    return ResultSuccess();
}

/*!
    @brief      コンテナにオブジェクトを登録します。

    @param[in]  pObj     対象のオブジェクト

*/
Result KObjectContainer::Register(KAutoObjectWithList* pObj)
{
    NN_KERN_THIS_ASSERT();
    KScopedLightLock locker(&m_Mutex);
    return RegisterImpl(pObj);
}

/*!
    @brief      コンテナからオブジェクトを削除します。

    @param[in]  pObj     対象のオブジェクト

    @return     常に成功を返します

*/
Result KObjectContainer::Unregister(KAutoObjectWithList* pObj)
{
    NN_KERN_THIS_ASSERT();
    KScopedLightLock locker(&m_Mutex);

#if defined NN_SDK_BUILD_DEVELOP || defined NN_SDK_BUILD_DEBUG
    bool found = false;
    for (ObjectList::iterator it = m_ObjectList.begin(); it != m_ObjectList.end(); it++)
    {
        if (&*it == pObj)
        {
            found = true;
            break;
        }
    }
    NN_WARNING(found, "Unregister Failed. Not Found %08x", pObj);
    NN_KERN_ABORT_UNLESS(found);
#endif
    ObjectList::iterator it = m_ObjectList.iterator_to(*pObj);
    m_ObjectList.erase(it);

    return nn::svc::ResultNotFound();
}

int32_t KObjectContainer::GetOwnedNum(KProcess* pOwner)
{
    NN_KERN_THIS_ASSERT();
    KScopedLightLock locker(&m_Mutex);

    int32_t count = 0;

    for (ObjectList::iterator it = m_ObjectList.begin(); it != m_ObjectList.end(); it++)
    {
        if (it->GetOwner() == pOwner)
        {
            count++;
        }
    }

    return count;
}



}}

