﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "kern_KTaggedAddress.h"

/*
 * Physical Layout
 * +-----+------+------+------------+-----------+------+-------+-----+
 * | Rsv | Code | Slab | Page Table | Boot Temp | Heap | Debug | Rsv |
 * +-----+------+------+------------+-----------+------+-------+-----+
 *                     |<- Linear Region --------------------->|
 *       |<- Kernel Region -------------------->|
 *       |<- 起動時の論物一致区間 ------------ ... ->
 *
 * - 起動時に Initial Process イメージを Page Table 領域にコピーする。
 *   ヒープの初期化、Initial Process をヒープにコピー、Page Table の初期化の順序を守る
 */

namespace nn { namespace kern {
// TODO: 将来、これをコアローカル領域に入れる
class KMemoryLayout
{
#define NN_KERN_KMEMORYLAYOUT_DETAIL_REGION(region, type)                                                       \
public:                                                                                                         \
    static void Set##region(type begin, size_t size)                                                            \
    {                                                                                                           \
        s_##region##Begin = begin;                                                                              \
        s_##region##Size = size;                                                                                \
    }                                                                                                           \
    static type Get##region##Begin() { return s_##region##Begin; }                                              \
    static type Get##region##End()   { return s_##region##Begin + s_##region##Size; }                           \
    static size_t Get##region##Size(){ return s_##region##Size; }                                               \
    static bool In##region(type a)   { return Get##region##Begin() <= (a) && (a) <= Get##region##End() - 1; }   \
private:                                                                                                        \
    static type s_##region##Begin;                                                                              \
    static size_t s_##region##Size;
    NN_KERN_KMEMORYLAYOUT_DETAIL_REGION(KernelRegion, KProcessAddress);
    NN_KERN_KMEMORYLAYOUT_DETAIL_REGION(LinearRegion, KVirtualAddress);
    NN_KERN_KMEMORYLAYOUT_DETAIL_REGION(CoreLocalRegion, KProcessAddress);
    NN_KERN_KMEMORYLAYOUT_DETAIL_REGION(HeapRegion, KVirtualAddress);
    NN_KERN_KMEMORYLAYOUT_DETAIL_REGION(MiscRegion, KProcessAddress);
    NN_KERN_KMEMORYLAYOUT_DETAIL_REGION(TempRegion, KProcessAddress);
    NN_KERN_KMEMORYLAYOUT_DETAIL_REGION(CodeRegion, KProcessAddress);
    NN_KERN_KMEMORYLAYOUT_DETAIL_REGION(StackRegion, KProcessAddress);
    NN_KERN_KMEMORYLAYOUT_DETAIL_REGION(SlabRegion, KProcessAddress);
    NN_KERN_KMEMORYLAYOUT_DETAIL_REGION(SlabRegionPhysical, KPhysicalAddress);
    NN_KERN_KMEMORYLAYOUT_DETAIL_REGION(KernelRegionPhysical, KPhysicalAddress);
    NN_KERN_KMEMORYLAYOUT_DETAIL_REGION(LinearRegionPhysical, KPhysicalAddress);
    NN_KERN_KMEMORYLAYOUT_DETAIL_REGION(HeapRegionPhysical, KPhysicalAddress);
    NN_KERN_KMEMORYLAYOUT_DETAIL_REGION(PtHeapRegionPhysical, KPhysicalAddress);
    NN_KERN_KMEMORYLAYOUT_DETAIL_REGION(DebugRegionPhysical, KPhysicalAddress);
#undef NN_KERN_KMEMORYLAYOUT_DETAIL_REGION

public:
    static KVirtualAddress ToLinearVirtualAddress(KPhysicalAddress phys)
    {
        return GetLinearRegionBegin() + (phys - GetLinearRegionPhysicalBegin());
    }
    static KPhysicalAddress ToLinearPhysicalAddress(KVirtualAddress virt)
    {
        return GetLinearRegionPhysicalBegin() + (virt - GetLinearRegionBegin());
    }

    static KProcessAddress GetMainStackBottom(int32_t coreNo);
    static KProcessAddress GetIdleStackBottom(int32_t coreNo);
    static KProcessAddress GetExceptionStackBottom(int32_t coreNo);

    static void SetMainStackBottom(int32_t coreNo, KProcessAddress addr);
    static void SetIdleStackBottom(int32_t coreNo, KProcessAddress addr);
    static void SetExceptionStackBottom(int32_t coreNo, KProcessAddress addr);
};

}}

