﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_Platform.h"
#include "kern_KMemoryLayout.h"
#include "kern_CPUSelect.h"

namespace nn { namespace kern {
namespace {
KProcessAddress s_MainStackBottom[KCPU::NUM_CORE];
KProcessAddress s_IdleStackBottom[KCPU::NUM_CORE];
KProcessAddress s_ExceptionStackBottom[KCPU::NUM_CORE];
}

#define NN_KERN_KMEMORYLAYOUT_DEFINE_REGION(region, type)  \
    type nn::kern::KMemoryLayout::s_##region##Begin;       \
    size_t nn::kern::KMemoryLayout::s_##region##Size

NN_KERN_KMEMORYLAYOUT_DEFINE_REGION(KernelRegion, KProcessAddress);
NN_KERN_KMEMORYLAYOUT_DEFINE_REGION(CoreLocalRegion, KProcessAddress);
NN_KERN_KMEMORYLAYOUT_DEFINE_REGION(LinearRegion, KVirtualAddress);
NN_KERN_KMEMORYLAYOUT_DEFINE_REGION(LinearRegionPhysical, KPhysicalAddress);
NN_KERN_KMEMORYLAYOUT_DEFINE_REGION(HeapRegion, KVirtualAddress);
NN_KERN_KMEMORYLAYOUT_DEFINE_REGION(HeapRegionPhysical, KPhysicalAddress);
NN_KERN_KMEMORYLAYOUT_DEFINE_REGION(PtHeapRegionPhysical, KPhysicalAddress);
NN_KERN_KMEMORYLAYOUT_DEFINE_REGION(MiscRegion, KProcessAddress);
NN_KERN_KMEMORYLAYOUT_DEFINE_REGION(TempRegion, KProcessAddress);
NN_KERN_KMEMORYLAYOUT_DEFINE_REGION(CodeRegion, KProcessAddress);
NN_KERN_KMEMORYLAYOUT_DEFINE_REGION(StackRegion, KProcessAddress);
NN_KERN_KMEMORYLAYOUT_DEFINE_REGION(SlabRegion, KProcessAddress);
NN_KERN_KMEMORYLAYOUT_DEFINE_REGION(SlabRegionPhysical, KPhysicalAddress);
NN_KERN_KMEMORYLAYOUT_DEFINE_REGION(KernelRegionPhysical, KPhysicalAddress);
NN_KERN_KMEMORYLAYOUT_DEFINE_REGION(DebugRegionPhysical, KPhysicalAddress);

KProcessAddress KMemoryLayout::GetMainStackBottom(int32_t coreNo)
{
    return s_MainStackBottom[coreNo];
}

KProcessAddress KMemoryLayout::GetIdleStackBottom(int32_t coreNo)
{
    return s_IdleStackBottom[coreNo];
}

KProcessAddress KMemoryLayout::GetExceptionStackBottom(int32_t coreNo)
{
    return s_ExceptionStackBottom[coreNo];
}

void KMemoryLayout::SetMainStackBottom(int32_t coreNo, KProcessAddress addr)
{
    s_MainStackBottom[coreNo] = addr;
}

void KMemoryLayout::SetIdleStackBottom(int32_t coreNo, KProcessAddress addr)
{
    s_IdleStackBottom[coreNo] = addr;
}

void KMemoryLayout::SetExceptionStackBottom(int32_t coreNo, KProcessAddress addr)
{
    s_ExceptionStackBottom[coreNo] = addr;
}


}}
