﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_Platform.h"
#include "kern_KLinkedList.h"

/****************************************************************************/
namespace nn {
namespace kern {
namespace old_lib {
namespace detail {
/****************************************************************************/


LinkedListImpl::~LinkedListImpl()
{
    Clear();
}

LinkedListImpl::Iterator LinkedListImpl::Erase(const Iterator& it)
{
    NW4R_ASSERT(it.mPointer!=&mNode);
    Iterator itNext=it;
    (void)++itNext;
    return Erase(it,itNext);
}


LinkedListImpl::Iterator LinkedListImpl::Erase(const Iterator& itFirst, const Iterator& itLast)
{
    Node *pIt=itFirst.mPointer,*const pItLast=itLast.mPointer,*pNext;
    for (; pIt!=pItLast ; pIt=pNext)
    {
        pNext=pIt->mNext;
        (void)Erase(pIt);
    }

    return itLast;
}


void LinkedListImpl::Clear()
{
    (void)Erase(GetBeginIter(),GetEndIter());
}

void LinkedListImpl::Reverse()
{
    if (IsEmpty())
    {
        return;
    }

    Node *p=mNode.mNext,*pNext;
    Initialize_();
    for (; p!=&mNode ; p=pNext)
    {
        pNext=p->mNext;
        p->mNext = NULL;
        p->mPrev = NULL;
        PushFront(p);
    }
}

LinkedListImpl::Iterator LinkedListImpl::Insert(Iterator it,pointer p)
{
    NW4R_NULL_ASSERT(p);
    Node *const pIt=it.mPointer;
    NW4R_NULL_ASSERT(pIt);

    Node *const pItPrev=pIt->mPrev;
    NW4R_NULL_ASSERT(pItPrev);

    NW4R_ASSERT(p->mNext == NULL);
    NW4R_ASSERT(p->mPrev == NULL);
    p->mNext=pIt;
    p->mPrev=pItPrev;

    pIt->mPrev=p;
    pItPrev->mNext=p;

    ++mSize;
    return Iterator(p);
}


LinkedListImpl::Iterator LinkedListImpl::Erase(pointer p)
{
    NW4R_ASSERT(!IsEmpty());
    NW4R_NULL_ASSERT(p);
    NW4R_ASSERT(p!=&mNode);

    Node *const pNext=p->mNext,*const pPrev=p->mPrev;
    NW4R_NULL_ASSERT(pNext);
    pNext->mPrev=pPrev;
    NW4R_NULL_ASSERT(pPrev);
    pPrev->mNext=pNext;
    --mSize;

    p->mNext = NULL;
    p->mPrev = NULL;

    return Iterator(pNext);
}

/****************************************************************************/
}  // namespace detail
}  // nemspace old_lib
}  // namespace util
}  // namespace nn

namespace nn { namespace kern {

KSlabAllocator<KLinkedListNode> KLinkedListNode::s_NodeAllocator;

}}
