﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include <nn/TargetConfigs/build_Base.h>

#if defined(NN_BUILD_CONFIG_HARDWARE_KZMA9)
    #include "board/kzma9/kern_KDevicePageTable.h"
    namespace nn { namespace kern {
        using namespace nn::kern::kzma9;
    }}
#elif   defined(NN_BUILD_CONFIG_HARDWARE_SMMA53)
    #include "board/smma53/kern_KDevicePageTable.h"
    namespace nn { namespace kern {
        using namespace nn::kern::smma53;
    }}
#elif   defined(NN_BUILD_CONFIG_HARDWARE_JUNO)
    #include "board/juno/kern_KDevicePageTable.h"
    namespace nn { namespace kern {
        using namespace nn::kern::juno;
    }}
#elif   defined(NN_BUILD_CONFIG_HARDWARE_BDSLIMX6)
    #include "board/bdslimx6/kern_KDevicePageTable.h"
    namespace nn { namespace kern {
        using namespace nn::kern::bdslimx6;
    }}
#elif   defined(NN_BUILD_CONFIG_SOC_TEGRA_K1) || defined(NN_BUILD_CONFIG_SOC_TEGRA_X1)
    #include "ip/tegra/kern_KDevicePageTable.h"
    namespace nn { namespace kern {
        using namespace nn::kern::tegra;
    }}
#elif   defined(NN_BUILD_CONFIG_SOC_TEGRA_X2)
    #include "ip/smmu-v2/kern_KDevicePageTable.h"
    namespace nn { namespace kern {
        using namespace nn::kern::smmuv2;
    }}
#else
    #error NN_BUILD_CONFIG_HARDWARE_ not defined
#endif

