﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*!
    @file

    @brief デバッグ出力 API の宣言

*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/svc/svc_Select.h>
#include <nn/svc/svc_Kernel.h>
#include <cstdarg>
#include "kern_Platform.h"
#include "svc/kern_KUserPointer.h"

// システムが安定するまで強制出力
#define NN_KERN_FATAL_LOG(...)              nn::kern::KPrintf(__VA_ARGS__)

#ifdef NN_KERN_FOR_DEVELOPMENT
    #define NN_KERN_RELEASE_LOG(...)        nn::kern::KPrintf(__VA_ARGS__)
    #define NN_KERN_RELEASE_VLOG(fmt, args) nn::kern::KVPrintf((fmt), (args))
#else   // ifdef NN_KERN_FOR_DEVELOPMENT
    #define NN_KERN_RELEASE_LOG(...)
    #define NN_KERN_RELEASE_VLOG(fmt, args)
#endif  // ifdef NN_KERN_FOR_DEVELOPMENT else

#ifndef NN_BUILD_DOCUMENT
    #ifndef NN_SWITCH_DISABLE_DEBUG_PRINT
        #define NN_LOG( ... )               nn::kern::KPrintf(__VA_ARGS__)
        #define NN_VLOG(fmt, args)          nn::kern::KVPrintf((fmt), (args))
    #else   // ifndef NN_SWITCH_DISABLE_DEBUG_PRINT
        #define NN_LOG( ... )
        #define NN_VLOG(fmt, args)
    #endif  // ifndef NN_SWITCH_DISABLE_DEBUG_PRINT else
#endif

namespace nn { namespace kern {
    void InitializeDebugLog(uintptr_t base);

    /*!
        @brief     文字列を出力します。
        @param[in]    fmt     一般的な printf のフォーマット文字列を指定します。

    */
    void KPrintf(const char* fmt, ...);

    /*!
        @brief     文字列を出力します。
        @param[in]    fmt     一般的な printf のフォーマット文字列を指定します。
        @param[in]    vlist   可変引数パラメータを指定します。

    */
    void KVPrintf(const char *fmt, ::std::va_list vlist);

    /*!
        @brief     文字列を出力します。
        @param[in]    text    出力文字列を指定します。

    */
    Result KOutputUserString(nn::kern::svc::KUserPointer<const char*> textUser, size_t byteSize);

    void SavePrintRegisters();
    void RestorePrintRegisters();
}}

namespace nn { namespace dbg {
    Result Break(nn::svc::BreakReason reason);
}}

extern "C" {
    void nndbgPrintWarning_ (const char* filename, int lineno, const char* fmt, ...);
}


