﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#ifdef NN_SWITCH_INCLUDE_FROM_NON_C
#define NN_KERN_UL(x)       (x)
#else
#define NN_KERN_UL(x)       x ## ull
#endif

#define HW_MAIR_ATTR_DEVICE_NGNRNE      NN_KERN_UL(0x00)
#define HW_MAIR_ATTR_DEVICE_NGNRE       NN_KERN_UL(0x04)

// Normal Memory
//      Inner Cacheable write allocate read allocate
//      Outer Cacheable write allocate read allocate
#define HW_MAIR_ATTR_NORMAL_ICRW_OCRW   NN_KERN_UL(0xFF)
#define HW_MAIR_ATTR_NORMAL_INC_ONC     NN_KERN_UL(0x44)

// index はソフト的な取り決め
#define HW_MMU_ATTRINDEX_DEVICE_NGNRNE  0
#define HW_MMU_ATTRINDEX_DEVICE_NGNRE   1
#define HW_MMU_ATTRINDEX_NORMAL         2
#define HW_MMU_ATTRINDEX_NORMAL_NC      3

#define HW_MMU_XN                       (NN_KERN_UL(1)<<54)
#define HW_MMU_PXN                      (NN_KERN_UL(1)<<53)
#define HW_MMU_CONTIGUOUS               (NN_KERN_UL(1)<<52)
#define HW_MMU_NGLOBAL                  (NN_KERN_UL(1)<<11)
#define HW_MMU_AF                       (NN_KERN_UL(1)<<10)
#define HW_MMU_SH_MASK                  (NN_KERN_UL(3)<<8)
#define HW_MMU_SH_NSHARED               (NN_KERN_UL(0)<<8)
#define HW_MMU_SH_OSHARED               (NN_KERN_UL(2)<<8)
#define HW_MMU_SH_ISHARED               (NN_KERN_UL(3)<<8)
#define HW_MMU_AP_MASK                  (NN_KERN_UL(3)<<6)
#define HW_MMU_AP_S_RW_U_NA             (NN_KERN_UL(0)<<6)
#define HW_MMU_AP_S_RW_U_RW             (NN_KERN_UL(1)<<6)
#define HW_MMU_AP_S_RO_U_NA             (NN_KERN_UL(2)<<6)
#define HW_MMU_AP_S_RO_U_RO             (NN_KERN_UL(3)<<6)
#define HW_MMU_NS                       (NN_KERN_UL(1)<<5)
#define HW_MMU_ATTRINDX(n)              ((n) <<2)

#define HW_MMU_UXNTABLE                 (NN_KERN_UL(1)<<60)
#define HW_MMU_PXNTABLE                 (NN_KERN_UL(1)<<59)

#define HW_MMU_APTABLE_U_NA             (NN_KERN_UL(1)<<61)

#define HW_MMU_PAGE_SHIFT               12
#define HW_MMU_PAGE_SIZE                (NN_KERN_UL(1) << HW_MMU_PAGE_SHIFT)
#define HW_MMU_PAGE_MASK                (~(HW_MMU_PAGE_SIZE - 1))
#define HW_MMU_PAGE_OFFSET              (HW_MMU_PAGE_SIZE - 1)

#define HW_MMU_PAGETABLE_SHIFT          12
#define HW_MMU_PAGETABLE_SIZE           (NN_KERN_UL(1) << HW_MMU_PAGETABLE_SHIFT)

#define HW_MMU_PTE_SHIFT                3
#define HW_MMU_PTE_SIZE                 (NN_KERN_UL(1) << HW_MMU_PTE_SHIFT)

#define HW_MMU_NUM_PTE_SHIFT            (HW_MMU_PAGETABLE_SHIFT - HW_MMU_PTE_SHIFT)
#define HW_MMU_NUM_PTE                  (NN_KERN_UL(1) << HW_MMU_NUM_PTE_SHIFT)

#define HW_MMU_L1_BLOCK_SHIFT           (HW_MMU_PAGE_SHIFT + 2 * (HW_MMU_PAGETABLE_SHIFT - HW_MMU_PTE_SHIFT))
#define HW_MMU_L1_BLOCK_SIZE            (NN_KERN_UL(1) << HW_MMU_L1_BLOCK_SHIFT)
#define HW_MMU_L2_BLOCK_SHIFT           (HW_MMU_PAGE_SHIFT + 1 * (HW_MMU_PAGETABLE_SHIFT - HW_MMU_PTE_SHIFT))
#define HW_MMU_L2_BLOCK_SIZE            (NN_KERN_UL(1) << HW_MMU_L2_BLOCK_SHIFT)

#define HW_MMU_ATTR_DEVICE_NGNRNE       HW_MMU_ATTRINDX(HW_MMU_ATTRINDEX_DEVICE_NGNRNE)
#define HW_MMU_ATTR_DEVICE_NGNRE        HW_MMU_ATTRINDX(HW_MMU_ATTRINDEX_DEVICE_NGNRE)
#define HW_MMU_ATTR_NORMAL              HW_MMU_ATTRINDX(HW_MMU_ATTRINDEX_NORMAL)
#define HW_MMU_ATTR_NORMAL_NC           HW_MMU_ATTRINDX(HW_MMU_ATTRINDEX_NORMAL_NC)

#define HW_MMU_PHYSICAL_ADDRESS_BITS    48
#define HW_MMU_PFN_MASK                 (((NN_KERN_UL(1) << HW_MMU_PHYSICAL_ADDRESS_BITS) - 1) & HW_MMU_PAGE_MASK)


